package com.bxm.fossicker.thirdpart.facade.service;

/**
 * 第三方广告监控回调
 *
 * @author liujia
 * @date 2019/12/19 17:37
 */
public interface ThirdpartyAdvertCallbakcService {

    /**
     * 用户激活时调用
     *
     * @param equipmentId 设备ID
     */
    void active(String equipmentId);

    /**
     * 用户登录成功时回调
     *
     * @param userId      用户ID
     * @param equipmentId 设备ID
     */
    void login(Long userId, String equipmentId);

    /**
     * 用户产生付费行为
     *
     * @param userId      付费用户ID
     * @param equipmentId 用户的设备ID
     */
    void payment(Long userId, String equipmentId);
}
