package com.bxm.game.common.core;


import com.bxm.game.common.core.activity.ActivityConfig;

/**
 * @author allen
 * @date 2020-10-14
 * @since 1.0
 */
public class AppContext {

    private static final ThreadLocal<AppContext> THREAD_LOCAL = new ThreadLocal<>();

    public static AppContext getInstance() {
        AppContext appContext = THREAD_LOCAL.get();
        if (null == appContext) {
            appContext = new AppContext();
            THREAD_LOCAL.set(appContext);
        }
        return appContext;
    }

    public static AppContext get() {
        return THREAD_LOCAL.get();
    }

    public static void remove() {
        THREAD_LOCAL.remove();
    }

    private String appId;
    private String uid;
    private ActivityConfig activityConfig;

    public AppContext setAppId(String appId) {
        this.appId = appId;
        return this;
    }

    public String getAppId() {
        return appId;
    }

    public AppContext setUid(String uid) {
        this.uid = uid;
        return this;
    }

    public String getUid() {
        return uid;
    }

    public AppContext setActivityConfig(ActivityConfig activityConfig) {
        this.activityConfig = activityConfig;
        return this;
    }

    public ActivityConfig getActivityConfig() {
        return activityConfig;
    }
}
