package com.bxm.game.common.core;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;

/**
 * @author allen
 * @date 2020-10-16
 * @since 1.0
 */
@Data
@Builder
@AllArgsConstructor
public class ErrCode {

    public static final ErrCode BAD_REQUEST = ErrCode.builder().code(400).statusCode(400).msg("BAD_REQUEST").build();
    public static final ErrCode INTERNAL_SERVER_ERROR = ErrCode.builder().code(500).statusCode(500).msg("INTERNAL_SERVER_ERROR").build();
    public static final ErrCode CONFIG_INVALID = ErrCode.builder().code(900).statusCode(500).msg("游戏配置无效").build();

    private int code;
    private int statusCode;
    private String msg;
}
