package com.bxm.game.common.core;

import com.bxm.warcar.cache.KeyGenerator;
import com.bxm.warcar.utils.DateHelper;
import com.bxm.warcar.utils.KeyBuilder;
import com.google.common.collect.Lists;

import java.util.Arrays;
import java.util.List;

/**
 * @author allen
 * @date 2020-10-16
 * @since 1.0
 */
public final class Key {

    public static final int EXPIRE_TIME_ONE_DAY = 24 * 60 * 60;
    private final AppConfig appConfig;

    public Key(AppConfig appConfig) {
        this.appConfig = appConfig;
    }

    /**
     * 创建自定义的 Key
     * @param keys Key 数组
     * @return 自定义的 KeyGenerator
     */
    public KeyGenerator generator(String...keys) {
        List<Object> list = Lists.newArrayList("game", appConfig.getApplicationName());
        list.addAll(Arrays.asList(keys));
        return () -> KeyBuilder.build(list.toArray(new Object[0]));
    }

    /**
     * 用户永久资产
     * @return 用户资产 KeyGenerator
     */
    public KeyGenerator getUserAsset() {
        return () -> KeyBuilder.build("game", appConfig.getApplicationName(), "assets", AppContext.get().getAppId(), AppContext.get().getUid());
    }

    /**
     * 用户永久数据
     * @return 当日数据 KeyGenerator
     */
    public KeyGenerator getPermanentDataForUser() {
        return () -> KeyBuilder.build("game", appConfig.getApplicationName(), "user", "0", AppContext.get().getAppId(), AppContext.get().getUid());
    }

    /**
     * 用户当日数据
     * @return 当日数据 KeyGenerator
     */
    public KeyGenerator getTodayDataForUser() {
        return () -> KeyBuilder.build("game", appConfig.getApplicationName(), "user", DateHelper.getDate(), AppContext.get().getAppId(), AppContext.get().getUid());
    }

    /**
     * 用户连续签到次数
     * @return 签到次数 KeyGenerator
     */
    public KeyGenerator getSignin() {
        return () -> KeyBuilder.build("game", appConfig.getApplicationName(), "signin", "times", AppContext.get().getAppId(), AppContext.get().getUid());
    }

    /**
     * 应用当日数据
     * @return 当日数据 KeyGenerator
     */
    public KeyGenerator getTodayDataForApp() {
        return () -> KeyBuilder.build("game", appConfig.getApplicationName(), "app", DateHelper.getDate(), AppContext.get().getAppId());
    }
}
