package com.bxm.game.common.core.assets;

import com.bxm.game.common.core.Key;
import com.bxm.warcar.cache.Counter;
import com.bxm.warcar.cache.Fetcher;
import com.bxm.warcar.cache.Updater;

import java.util.Map;
import java.util.Optional;

/**
 * @author allen
 * @date 2020-11-26
 * @since 1.0
 */
public class AssetServiceImpl implements AssetService {

    private final Fetcher fetcher;
    private final Updater updater;
    private final Counter counter;
    private final Key key;

    public AssetServiceImpl(Fetcher fetcher, Updater updater, Counter counter, Key key) {
        this.fetcher = fetcher;
        this.updater = updater;
        this.counter = counter;
        this.key = key;
    }

    @Override
    public long plus(String type, int value) {
        return counter.hincrementByAndGet(key.getUserAsset(), type, value);
    }

    @Override
    public int get(String type) {
        return Optional.ofNullable(fetcher.hfetch(key.getUserAsset(), type, Integer.class)).orElse(0);
    }

    @Override
    public Map<String, Integer> getAll() {
        return fetcher.hfetchall(key.getUserAsset(), Integer.class);
    }
}
