package com.bxm.game.common.core.interceptor;

import com.bxm.game.common.core.AppContext;
import com.bxm.game.common.core.activity.ActivityConfig;
import com.bxm.game.common.core.activity.ActivityService;
import org.apache.commons.lang.StringUtils;
import org.springframework.http.HttpStatus;
import org.springframework.web.servlet.HandlerInterceptor;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/**
 * @author allen
 * @date 2020-10-14
 * @since 1.0
 */
public class AppContextInterceptor implements HandlerInterceptor {

    private final ActivityService activityService;

    public AppContextInterceptor(ActivityService activityService) {
        this.activityService = activityService;
    }

    @Override
    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        String appid = request.getHeader("x-appid");
        String device = request.getHeader("x-device");
        if (StringUtils.isBlank(appid) || StringUtils.isBlank(device)) {
            response.setStatus(HttpStatus.ACCEPTED.value());
            return false;
        }
        AppContext.getInstance().setAppId(appid).setUid(device);
        ActivityConfig config = activityService.getConfig();
        AppContext.getInstance().setActivityConfig(config);
        return true;
    }

    @Override
    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) throws Exception {
        AppContext.remove();
    }
}
