package com.bxm.game.common.core.prop;

import com.bxm.game.common.core.assets.AssetService;

/**
 * 抽象的道具授予者
 *
 * @author allen
 * @date 2020-11-26
 * @since 1.0
 */
public abstract class AbstractPropGrantor implements PropGrantor {

    private final AssetService assetService;

    public AbstractPropGrantor(AssetService assetService) {
        this.assetService = assetService;
    }

    @Override
    public void single(Prop prop) {
        assetService.plus(prop.getAssetType(), prop.propNum());
    }

    @Override
    public void multiple(Prop prop) {
        assetService.plus(getAssetType(), prop.propNum() * prop.multipleNum());
    }
}
