package com.bxm.game.common.core.prop;

import lombok.Data;
import lombok.experimental.Accessors;

import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;

/**
 * @author allen
 * @date 2020-10-19
 * @since 1.0
 */
@Data
@Accessors(chain = true)
public class AcquiredPropLog {

    private String assetType;

    private String sceneType;
    private String id;
    private String appId;
    private String uid;

    /**
     * 道具数
     */
    private int propNum;
    /**
     * 翻倍数
     */
    private int multipleNum;
    /**
     * 是否已经翻倍处理了
     */
    private boolean completedMultiple;
    /**
     * 是否已兑换
     */
    private boolean acquired;
    /**
     * 可获取的时间
     */
    private long startAcquireTime;
    /**
     * 过期时间
     */
    private long endAcquireTime;

    /**
     * 当前时间是否在可领取的有效时间内
     * @return 返回 true 则可领取
     */
    public boolean isBetweenAcquireTime() {
        return LocalDateTime.now().isAfter(getAcquireTimeInMillis()) &&
                (endAcquireTime == 0 || LocalDateTime.now().isBefore(getExpiredTimeInMillis()));
    }

    private LocalDateTime getAcquireTimeInMillis() {
        return LocalDateTime.ofInstant(Instant.ofEpochMilli(getStartAcquireTime()), ZoneId.systemDefault());
    }

    private LocalDateTime getExpiredTimeInMillis() {
        return LocalDateTime.ofInstant(Instant.ofEpochMilli(getEndAcquireTime()), ZoneId.systemDefault());
    }
}
