package com.bxm.game.common.core.prop;

/**
 * 道具授予
 *
 * @author allen
 * @date 2020-11-26
 * @since 1.0
 */
public interface PropGrantor {

    /**
     * @return 资产类型
     */
    String getAssetType();

    /**
     * 授予单额道具数量，将道具变成资产保存到用户资产中。
     * @param prop 道具
     */
    void single(Prop prop);

    /**
     * 授予翻倍道具数量，将道具变成资产保存到用户资产中。
     * @param prop 道具
     */
    void multiple(Prop prop);

    /**
     * 根据记录重新构建一个道具
     * @param log 记录
     * @return 道具
     */
    Prop rebuild(AcquiredPropLog log);
}
