package com.bxm.game.common.core.prop;


/**
 * @author allen
 * @date 2020-10-14
 * @since 1.0
 */
public interface PropService {

    /**
     * 保存得到道具的记录
     * @param log 记录
     * @return 保存是否成功
     */
    boolean saveTakeLog(AcquiredPropLog log);

    /**
     * 根据得到的ID获取记录
     * @param id ID
     * @return 记录
     */
    AcquiredPropLog getTakeLog(String id);

    /**
     * 根据道具记录重建一个道具
     * @param log 道具记录
     * @return 道具
     */
    Prop rebuild(AcquiredPropLog log);
}
