package com.bxm.game.common.core.prop;

import com.bxm.game.common.core.AppConfig;
import com.bxm.game.common.core.Key;
import com.bxm.warcar.cache.Fetcher;
import com.bxm.warcar.cache.KeyGenerator;
import com.bxm.warcar.cache.Updater;
import com.bxm.warcar.utils.KeyBuilder;
import lombok.extern.slf4j.Slf4j;

import java.util.Objects;
import java.util.Optional;

/**
 * @author allen
 * @date 2020-10-14
 * @since 1.0
 */
@Slf4j
public class PropServiceImpl implements PropService {

    private final AppConfig appConfig;
    private final Fetcher fetcher;
    private final Updater updater;
    private final PropGrantorFactory propGrantorFactory;

    public PropServiceImpl(AppConfig appConfig, Fetcher fetcher, Updater updater, PropGrantorFactory propGrantorFactory) {
        this.appConfig = appConfig;
        this.fetcher = fetcher;
        this.updater = updater;
        this.propGrantorFactory = propGrantorFactory;
    }

    @Override
    public boolean saveTakeLog(AcquiredPropLog log) {
        if (Objects.isNull(log) || Objects.isNull(log.getId())) {
            return true;
        }
        updater.update(hash(log.getId()), log, Key.EXPIRE_TIME_ONE_DAY);
        return true;
    }

    @Override
    public AcquiredPropLog getTakeLog(String id) {
        AcquiredPropLog propLog = fetcher.fetch(hash(id), AcquiredPropLog.class);
        return Optional.ofNullable(propLog).orElse(null);
    }

    @Override
    public Prop rebuild(AcquiredPropLog log) {
        PropGrantor grantor = propGrantorFactory.get(log.getAssetType());
        return grantor.rebuild(log);
    }

    private KeyGenerator hash(String id) {
        return () -> KeyBuilder.build("game", appConfig.getApplicationName(), "take_log", id);
    }
}
