package com.bxm.game.common.core.scene;

/**
 * @author allen
 * @date 2020-10-16
 * @since 1.0
 */
public interface SceneService<R extends SceneRequest, T extends SceneResponse> {

    /**
     * 如果获得的道具允许翻倍，该场景是否翻倍，默认不翻倍。
     * @return 是否翻倍
     */
    default boolean isMultipleGrant() {
        return false;
    }

    /**
     * 返回场景类型
     * @return 场景类型
     */
    String getSceneType();

    /**
     * 发放道具
     * @param request 场景请求
     * @return 场景响应
     */
    T take(R request);

    /**
     * 返回场景请求对象类
     * @return 场景请求对象类
     */
    Class<R> getRequestClass();

    /**
     * 将原始请求的内容转换成请求对象
     * @param message 原始请求
     * @return 请求对象实例
     */
    R convert(String message);
}
