package com.bxm.game.common.core.scene.event;

import com.bxm.game.common.core.prop.Prop;
import lombok.Getter;

import java.util.EventObject;

/**
 * @author allen
 * @date 2020-10-15
 * @since 1.0
 */
@Getter
public class AcquiredPropEvent extends EventObject {

    private final String id;
    private final String sceneType;
    private final Prop prop;
    /**
     * 是否翻倍处理
     */
    private final boolean multiple;

    public AcquiredPropEvent(Object source, String id, String sceneType, Prop prop, boolean multiple) {
        super(source);
        this.id = id;
        this.sceneType = sceneType;
        this.prop = prop;
        this.multiple = multiple;
    }
}
