package com.bxm.game.common.core.scene.listeners;

import com.bxm.game.common.core.AppContext;
import com.bxm.game.common.core.prop.AcquiredPropLog;
import com.bxm.game.common.core.prop.Prop;
import com.bxm.game.common.core.prop.PropService;
import com.bxm.game.common.core.scene.event.AcquiredPropEvent;
import com.bxm.warcar.integration.eventbus.EventListener;
import com.bxm.warcar.integration.eventbus.core.Subscribe;
import lombok.extern.slf4j.Slf4j;

/**
 * @author allen
 * @date 2020-10-15
 * @since 1.0
 */
@Slf4j
public class AcquiredPropLogListener implements EventListener<AcquiredPropEvent> {

    private final PropService propService;

    public AcquiredPropLogListener(PropService propService) {
        this.propService = propService;
    }

    @Override
    @Subscribe
    public void consume(AcquiredPropEvent event) {
        Prop prop = event.getProp();

        AcquiredPropLog takePropLog = new AcquiredPropLog();
        takePropLog
                .setAssetType(prop.getAssetType())
                .setSceneType(event.getSceneType())
                .setId(event.getId())
                .setAppId(AppContext.get().getAppId())
                .setUid(AppContext.get().getUid())
                .setPropNum(prop.propNum())
                .setMultipleNum(prop.multipleNum())
                .setCompletedMultiple(false)
                .setAcquired(prop.acquired())
                .setStartAcquireTime(prop.startAcquireTime())
                .setEndAcquireTime(prop.endAcquireTime());

        if (log.isDebugEnabled()) {
            log.debug("--- 保存获得道具记录：{}", takePropLog.toString());
        }

        if (!propService.saveTakeLog(takePropLog)) {
            log.warn("save take log fail!\n{}", takePropLog);
        }
    }
}
