package com.bxm.game.common.core.scene.listeners;

import com.bxm.game.common.core.prop.Prop;
import com.bxm.game.common.core.prop.PropGrantor;
import com.bxm.game.common.core.prop.PropGrantorFactory;
import com.bxm.game.common.core.scene.event.AcquiredPropEvent;
import com.bxm.warcar.integration.eventbus.EventListener;
import com.bxm.warcar.integration.eventbus.core.Subscribe;
import lombok.extern.slf4j.Slf4j;

import java.util.Objects;

/**
 * 发放道具
 *
 * @author allen
 * @date 2020-10-19
 * @since 1.0
 */
@Slf4j
public class GrantPropListener implements EventListener<AcquiredPropEvent> {

    private final PropGrantorFactory factory;

    public GrantPropListener(PropGrantorFactory factory) {
        this.factory = factory;
    }

    @Override
    @Subscribe
    public void consume(AcquiredPropEvent event) {
        Prop prop = event.getProp();
        PropGrantor grantor = factory.get(prop.getAssetType());

        if (Objects.isNull(grantor)) {
            log.warn("Not found grantor: {}", prop.getClass());
        }

        if (!prop.acquired()) {
            return;
        }
        if (event.isMultiple() && prop.multipleNum() > 1) {
            grantor.multiple(prop);
        } else {
            grantor.single(prop);
        }
    }
}
