package com.bxm.game.common.core.scene.multiple;

import com.bxm.game.common.core.AppContext;
import com.bxm.game.common.core.prop.AcquiredPropLog;
import com.bxm.game.common.core.prop.Prop;
import com.bxm.game.common.core.prop.PropService;
import com.bxm.game.common.core.scene.AbstractSceneService;
import com.bxm.game.common.core.scene.AcquiringOrMultiplyPropEvent;
import com.bxm.game.common.core.scene.SceneType;
import org.apache.commons.lang.StringUtils;

import java.util.Map;
import java.util.Objects;

/**
 * @author allen
 * @date 2020-11-26
 * @since 1.0
 */
public class MultipleSceneServiceImpl extends AbstractSceneService<MultipleSceneRequest, MultipleSceneResponse> {

    private final PropService propService;

    public MultipleSceneServiceImpl(PropService propService) {
        this.propService = propService;
    }

    @Override
    public boolean isMultipleGrant() {
        return true;
    }

    @Override
    protected Prop takeProp(MultipleSceneRequest request, Map<Object, Object> attach) {
        if (Objects.isNull(request)) {
            return null;
        }
        String appId = AppContext.get().getAppId();
        String uid = AppContext.get().getUid();
        String id = request.getId();
        AcquiredPropLog takeLog = propService.getTakeLog(id);
        if (Objects.isNull(takeLog)) {
            return null;
        }
        if (!(StringUtils.equals(appId, takeLog.getAppId())
                && StringUtils.equals(uid, takeLog.getUid())
                && !takeLog.isAcquired()
                && !takeLog.isCompletedMultiple()
                && takeLog.getMultipleNum() > 1)) {
            return null;
        }
        Prop prop = propService.rebuild(takeLog);
        if (Objects.nonNull(prop)) {
            propService.saveTakeLog(takeLog.setAcquired(true).setCompletedMultiple(true));
        }
        return prop;
    }

    @Override
    protected MultipleSceneResponse createResponse(MultipleSceneRequest request, String id, Prop prop, Map<Object, Object> attach) {
        return new MultipleSceneResponse();
    }

    @Override
    protected void afterCompletion(MultipleSceneRequest request, MultipleSceneResponse response, Prop prop, Map<Object, Object> attach) {
        getSyncEventPark().post(new MultipleSceneEvent(this, request, response));
        getSyncEventPark().post(new AcquiringOrMultiplyPropEvent(this, request, response));
    }

    @Override
    public String getSceneType() {
        return SceneType.MULTIPLE;
    }

    @Override
    public Class<MultipleSceneRequest> getRequestClass() {
        return MultipleSceneRequest.class;
    }
}
