package com.bxm.game.common.core.user.redis;

import com.bxm.game.common.core.Key;
import com.bxm.game.common.core.user.PermanentAtomicService;
import com.bxm.warcar.cache.Counter;
import com.bxm.warcar.cache.Fetcher;

import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;

/**
 * @author allen
 * @date 2020-11-30
 * @since 1.0
 */
public class RedisPermanentAtomicServiceImpl implements PermanentAtomicService {

    private final Key key;
    private final Fetcher fetcher;
    private final Counter counter;

    public RedisPermanentAtomicServiceImpl(Key key, Fetcher fetcher, Counter counter) {
        this.key = key;
        this.fetcher = fetcher;
        this.counter = counter;
    }

    @Override
    public Map<String, Object> getAll() {
        return fetcher.hfetchall(this.key.getPermanentDataForUser(), Object.class);
    }

    @Override
    public long get(String key) {
        return Optional.ofNullable(fetcher.hfetch(this.key.getPermanentDataForUser(), key, Long.class)).orElse(0L);
    }

    @Override
    public long incrementBy(String key, long value) {
        return counter.hincrementByAndGet(this.key.getPermanentDataForUser(), key, value);
    }

    @Override
    public boolean incrementBy(String key, long value, Predicate<Long> predicate) {
        long after = this.incrementBy(key, value);
        return predicate.test(after);
    }
}
