package com.bxm.game.common.core.user.redis;

import com.bxm.game.common.core.Key;
import com.bxm.game.common.core.user.TodayAtomicService;
import com.bxm.warcar.cache.Counter;
import com.bxm.warcar.cache.Fetcher;

import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;

/**
 * @author allen
 * @date 2020-11-27
 * @since 1.0
 */
public class RedisTodayAtomicServiceImpl implements TodayAtomicService {

    private final Key key;
    private final Fetcher fetcher;
    private final Counter counter;

    public RedisTodayAtomicServiceImpl(Key key, Fetcher fetcher, Counter counter) {
        this.key = key;
        this.fetcher = fetcher;
        this.counter = counter;
    }

    @Override
    public Map<String, Object> getAll() {
        return fetcher.hfetchall(this.key.getTodayDataForUser(), Object.class);
    }

    @Override
    public long get(String key) {
        return Optional.ofNullable(counter.hget(this.key.getTodayDataForUser(), key)).orElse(0L);
    }

    @Override
    public long incrementBy(String key, long value) {
        return Optional.ofNullable(counter.hincrementByAndGet(this.key.getTodayDataForUser(), key, value, Key.EXPIRE_TIME_ONE_DAY)).orElse(0L);
    }

    @Override
    public boolean incrementBy(String key, long value, Predicate<Long> predicate) {
        long l = this.incrementBy(key, value);
        return predicate.test(l);
    }
}
