package com.bxm.game.common.core.vo;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.Map;

/**
 * 存档
 *
 * @author allen
 * @date 2020-10-19
 * @since 1.0
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class ArchiveVo {

    /**
     * 今日数据
     */
    private Map<String, Object> today;
    /**
     * 永久数据
     */
    private Map<String, Object> permanent;
    /**
     * 资产
     */
    private Map<String, Integer> assets;
    /**
     * 自定义
     */
    private Map<String, Object> custom;
    /**
     * 连续签到天数
     */
    private long continuousSignInDays;
    /**
     * 服务器时间
     */
    private long time;
}
