package com.bxm.game.common.core.vo;

import com.bxm.game.common.core.controllers.ArchiveController;

/**
 * <p>自定义存档获取器</p>
 * 通过该接口的方法 {@link #getKey()} 获取的值将设置到返回结果的 {@code custom} 节点中，对应的值则是 {@link #getValue()}。
 *
 * <pre>
 *     示例：
 *
 *     如果 getKey() 返回的值是：demo，getValue() 返回的值是一个字符串：Hello,world!
 *
 *     那么最后通过接口 {@link ArchiveController#fetch()} 获取的 ArchiveVo 的结果则是：
 *     {
 *         "today" : {...}
 *         "custom" : {
 *             "demo" : "Hello,world!"
 *         }
 *     }
 * </pre>
 *
 * @author allen
 * @date 2020-12-01
 * @since 1.0
 */
public interface CustomArchiveFetcher {

    /**
     * 返回自定义对象中对应的属性名
     * @return 属性名
     */
    String getKey();

    /**
     * 返回自定义对象中对应的属性值
     * @return 属性值
     */
    Object getValue();
}
