package com.bxm.game.common.core.web;

import com.bxm.game.common.core.activity.ActivityService;
import com.bxm.game.common.core.interceptor.AppContextInterceptor;
import org.springframework.context.annotation.Bean;
import org.springframework.core.Ordered;
import org.springframework.web.cors.CorsConfiguration;
import org.springframework.web.cors.UrlBasedCorsConfigurationSource;
import org.springframework.web.filter.CorsFilter;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

/**
 * @author allen
 * @date 2020-10-14
 * @since 1.0
 */
public class GlobalMvcConfigurer implements WebMvcConfigurer {

    private final ActivityService activityService;

    public GlobalMvcConfigurer(ActivityService activityService) {
        this.activityService = activityService;
    }

    @Bean
    public AppContextInterceptor appContextInterceptor() {
        return new AppContextInterceptor(activityService);
    }

    @Override
    public void addInterceptors(InterceptorRegistry registry) {
        registry.addInterceptor(appContextInterceptor()).order(Ordered.HIGHEST_PRECEDENCE).addPathPatterns("/**");
    }

    @Bean
    public CorsFilter corsFilter() {
        // 有 Interceptor 拦截器的情况下必须使用这种方式，不能使用该接口的 #addCorsMappings，否则可能因为顺序问题而跨域设置无效。
        CorsConfiguration configuration = new CorsConfiguration();
        configuration.addAllowedOrigin(CorsConfiguration.ALL);
        configuration.addAllowedHeader(CorsConfiguration.ALL);
        configuration.addAllowedMethod(CorsConfiguration.ALL);
        configuration.setAllowCredentials(true);

        UrlBasedCorsConfigurationSource source = new UrlBasedCorsConfigurationSource();
        source.registerCorsConfiguration("/**", configuration);
        return new CorsFilter(source);
    }
}
