package com.bxm.game.common.core;

import com.google.common.collect.Lists;

import java.util.List;

/**
 * @author allen
 * @date 2020-12-09
 * @since 1.0
 */
public interface AppConfigFetcher {

    /**
     * 服务是否开放，如果返回 {@code false}，那么所以的请求都会被拒绝。
     * @return 是否开放中
     */
    default boolean isOpening() {
        return true;
    }

    /**
     * 空间名称，如果需要数据在不同的项目里互通，那么请设置成一致的名称。
     * @return 空间名称
     */
    String namespace();

    /**
     * 资产数据是否使用 APP 维度
     *
     * @return 是则APP间隔离，否则不隔离
     * @see com.bxm.game.common.core.assets.AssetService
     */
    default boolean assetWithApp() {
        return true;
    }

    /**
     * 用户永久数据是否使用 APP 维度
     *
     * @return 是则APP间隔离，否则不隔离
     * @see com.bxm.game.common.core.user.PermanentAtomicService
     */
    default boolean permanentWithApp() {
        return true;
    }

    /**
     * 用户今日数据是否使用 APP 维度
     *
     * @return 是则APP间隔离，否则不隔离
     * @see com.bxm.game.common.core.user.PermanentAtomicService
     */
    default boolean todayWithApp() {
        return true;
    }

    /**
     * 临时数据是否使用 APP 维度
     *
     * @return  是则APP间隔离，否则不隔离
     * @see com.bxm.game.common.core.user.TemporaryAtomicService
     */
    default boolean temporaryWithApp() {
        return true;
    }

    /**
     * AppContextInterceptor 排除的路径，不排除的话默认会校验 x-appid 等必要参数。
     * @return 排除的路径
     */
    default List<String> excludePathPatternsOfAppContextInterceptor() {
        return Lists.newArrayList();
    }

    /**
     * 返回数据库名称
     * @return 数据库名称，默认：{@code activity}
     */
    default String databaseName() {
        return "activity";
    }
}
