package com.bxm.game.common.core;


import com.bxm.game.common.core.activity.ActivityConfig;
import com.bxm.warcar.integration.dc.dot.Device;

/**
 * @author allen
 * @date 2020-10-14
 * @since 1.0
 */
public class AppContext {

    private static final ThreadLocal<AppContext> THREAD_LOCAL = new ThreadLocal<>();

    public static AppContext getInstance() {
        AppContext appContext = THREAD_LOCAL.get();
        if (null == appContext) {
            appContext = new AppContext();
            THREAD_LOCAL.set(appContext);
        }
        return appContext;
    }

    public static AppContext get() {
        return THREAD_LOCAL.get();
    }

    public static void remove() {
        THREAD_LOCAL.remove();
    }

    private String appId;
    private String uid;
    private String did;
    private Device device;
    private ActivityConfig activityConfig;

    public AppContext setAppId(String appId) {
        this.appId = appId;
        return this;
    }

    public String getAppId() {
        return appId;
    }

    public AppContext setUid(String uid) {
        this.uid = uid;
        return this;
    }

    public String getUid() {
        return uid;
    }

    public String getDid() {
        return did;
    }

    public AppContext setDid(String did) {
        this.did = did;
        return this;
    }

    public Device getDevice() {
        return device;
    }

    public AppContext setDevice(Device device) {
        this.device = device;
        return this;
    }

    public AppContext setActivityConfig(ActivityConfig activityConfig) {
        this.activityConfig = activityConfig;
        return this;
    }

    public ActivityConfig getActivityConfig() {
        return activityConfig;
    }
}
