package com.bxm.game.common.core.activity.dao;

import com.bxm.game.common.core.AppConfig;
import com.bxm.game.common.core.ErrCode;
import com.bxm.game.common.core.GameException;
import com.bxm.game.common.core.activity.ActivityConfig;
import com.bxm.warcar.cache.Fetcher;
import com.bxm.warcar.cache.KeyGenerator;
import com.bxm.warcar.utils.KeyBuilder;

import java.util.Objects;

/**
 * @author allen
 * @date 2020-10-19
 * @since 1.0
 */
public class DefaultActivityDaoImpl implements ActivityDao {

    private final AppConfig appConfig;
    private final Fetcher fetcher;

    public DefaultActivityDaoImpl(AppConfig appConfig, Fetcher fetcher) {
        this.appConfig = appConfig;
        this.fetcher = fetcher;
    }

    @Override
    public ActivityConfig get(String appId) {
        ActivityCachingConfig caching = getCaching(appId);
        if (Objects.isNull(caching)) {
            caching = getCaching("default");
            if (Objects.isNull(caching)) {
                throw new GameException(ErrCode.CONFIG_INVALID);
            }
        }

        ActivityConfig.ActivityConfigBuilder builder = ActivityConfig.builder();

        builder.appId(caching.getAppId());
        builder.title(caching.getTitle());

        return builder.build();
    }

    private ActivityCachingConfig getCaching(String appId) {
        return fetcher.hfetch(hash(), appId, ActivityCachingConfig.class);
    }

    private KeyGenerator hash() {
        return () -> KeyBuilder.build("game", appConfig.getNamespace(), "config");
    }
}
