package com.bxm.game.common.core.archives;

import com.bxm.game.common.core.AppContext;
import com.bxm.game.common.core.Key;
import com.bxm.warcar.cache.KeyGenerator;
import com.bxm.warcar.utils.DateHelper;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.Collection;

/**
 * @author allen
 * @date 2020-12-08
 * @since 1.0
 */
public abstract class AbstractCustomArchiveHandler<T> implements SceneCustomArchiveHandler<T> {

    private Key key;
    private CustomArchiveDataService customArchiveDataService;

    @Autowired
    public void setKey(Key key) {
        this.key = key;
    }

    @Autowired
    public void setCustomArchiveDataService(CustomArchiveDataService customArchiveDataService) {
        this.customArchiveDataService = customArchiveDataService;
    }

    @Override
    public KeyGenerator getKey() {
        return this.key.generator(getDisplayFieldName(), DateHelper.getDate(), AppContext.get().getAppId(), AppContext.get().getUid());
    }

    @Override
    public Collection<T> getArchiveObjects() {
        String s = getKey().generateKey();
        return customArchiveDataService.hgetAll(s, getClazz());
    }
}
