package com.bxm.game.common.core.archives;

import com.bxm.game.common.core.archives.annotation.DeleteOnCompleted;
import com.bxm.game.common.core.scene.event.AcquiredPropEvent;
import com.bxm.warcar.integration.eventbus.EventListener;
import com.bxm.warcar.integration.eventbus.core.Subscribe;
import com.google.common.collect.ImmutableSet;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang.ArrayUtils;
import org.springframework.util.ClassUtils;

import java.util.Objects;

/**
 * @author allen
 * @date 2020-12-09
 * @since 1.0
 */
@Slf4j
public class CustomArchiveDeleteOnCompletedListener implements EventListener<AcquiredPropEvent> {

    private final CustomArchiveHandlerFactory customArchiveHandlerFactory;
    private final CustomArchiveDataService customArchiveDataService;

    public CustomArchiveDeleteOnCompletedListener(CustomArchiveHandlerFactory customArchiveHandlerFactory, CustomArchiveDataService customArchiveDataService) {
        this.customArchiveHandlerFactory = customArchiveHandlerFactory;
        this.customArchiveDataService = customArchiveDataService;
    }

    @Override
    @Subscribe
    public void consume(AcquiredPropEvent event) {
        final ImmutableSet<CustomArchiveHandler> handlers = customArchiveHandlerFactory.getHandlers();
        for (CustomArchiveHandler handler : handlers) {
            if (!(handler instanceof SceneCustomArchiveHandler)) {
                continue;
            }
            SceneCustomArchiveHandler sceneCustomArchiveHandler = ((SceneCustomArchiveHandler) handler);
            final DeleteOnCompleted delete = ClassUtils.getUserClass(sceneCustomArchiveHandler.getClass()).getAnnotation(DeleteOnCompleted.class);
            if (Objects.isNull(delete)) {
                continue;
            }
            final String[] sceneTypes = delete.sceneTypes();
            if (!ArrayUtils.contains(sceneTypes, event.getSceneType())) {
                continue;
            }
            try {
                final String key = sceneCustomArchiveHandler.getKey().generateKey();
                final String field = event.getSceneRequest().getId();
                customArchiveDataService.hdel(key, field);
            } catch (Exception e) {
                log.warn("ignore exception: ", e);
            }
        }
    }
}
