package com.bxm.game.common.core.archives;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;

import java.util.Set;

/**
 * @author allen
 * @date 2020-12-01
 * @since 1.0
 */
@Slf4j
public class CustomArchiveHandlerFactory implements BeanPostProcessor {

    private final Set<CustomArchiveHandler> handlers = Sets.newHashSet();

    @Override
    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        if (bean instanceof CustomArchiveHandler) {
            handlers.add((CustomArchiveHandler) bean);
            log.info("Registering CustomArchiveHandler to Factory: {}", bean);
        }
        return bean;
    }

    public ImmutableSet<CustomArchiveHandler> getHandlers() {
        return ImmutableSet.copyOf(handlers);
    }
}
