package com.bxm.game.common.core.assets;

import com.bxm.game.common.core.assets.dao.AssetDao;

import java.util.HashMap;
import java.util.Map;

import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;

/**
 * @author allen
 * @date 2020-11-26
 * @since 1.0
 */
@ConditionalOnMissingBean(AssetService.class)
public class AssetServiceImpl implements AssetService {

    private final AssetDao assetDao;

    public AssetServiceImpl(AssetDao assetDao) {
        this.assetDao = assetDao;
    }

    @Override
    public long plus(String type, int value) {
        return assetDao.plus(type, value);
    }

    @Override
    public long minus(String type, int value) {
        return assetDao.minus(type, value);
    }

    @Override
    public int get(String type) {
        return assetDao.get(type);
    }

    @Override
    public Map<String, Object> getAll() {
        Map<String, Object> resp = new HashMap<>();
        Map<String, Integer> map = assetDao.getAll();
        if(null != map){
            map.forEach((k,v)-> resp.put(k,v));
        }
        return resp;
    }
}
