package com.bxm.game.common.core.assets.dao;

import java.util.Map;

/**
 * @author allen
 * @date 2020-12-15
 * @since 1.0
 */
public interface AssetDao {

    /**
     * 增加资产
     *
     * @param type 资产类型
     * @param value 资产值
     * @return 增加之后的值
     */
    long plus(String type, int value);

    /**
     * 减少资产
     * @param type 资产类型
     * @param value 资产值
     * @return 减少之后的值
     */
    long minus(String type, int value);

    /**
     * 获取资产
     *
     * @param type 资产类型
     * @return 资产
     */
    int get(String type);

    /**
     * 获取全部资产
     *
     * @return 资产
     */
    Map<String, Integer> getAll();
}
