package com.bxm.game.common.core.assets.dao;

import com.bxm.game.common.core.AppContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.PreparedStatementSetter;
import org.springframework.jdbc.core.ResultSetExtractor;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;
import java.util.Optional;

/**
 * @author allen
 * @date 2020-12-15
 * @since 1.0
 */
public class DbAssetDaoImpl implements AssetDao {

    @Autowired
    private JdbcTemplate jdbcTemplate;

    @Override
    public long plus(String type, int value) {
        StringBuilder sql = new StringBuilder();
        sql.append("UPDATE user_assets SET ").append(type).append(" = ").append(type).append(" + ? WHERE app_id = ? AND uid = ?");
        final int rs = jdbcTemplate.update(sql.toString(), new PreparedStatementSetter() {
            @Override
            public void setValues(PreparedStatement preparedStatement) throws SQLException {
                preparedStatement.setInt(1, value);
                preparedStatement.setString(2, AppContext.get().getAppId());
                preparedStatement.setString(3, AppContext.get().getUid());
            }
        });
        if (rs == 0) {
            Integer rows = jdbcTemplate.query("SELECT count(1) FROM user_assets WHERE app_id = ? AND uid = ?", new PreparedStatementSetter() {
                @Override
                public void setValues(PreparedStatement preparedStatement) throws SQLException {
                    preparedStatement.setString(1, AppContext.get().getAppId());
                    preparedStatement.setString(2, AppContext.get().getUid());
                }
            }, new ResultSetExtractor<Integer>() {
                @Override
                public Integer extractData(ResultSet resultSet) throws SQLException, DataAccessException {
                    return resultSet.getInt(1);
                }
            });
            if (Optional.ofNullable(rows).orElse(0) == 0) {
                // New

            }
        }
        return 0;
    }

    @Override
    public long minus(String type, int value) {
        return 0;
    }

    @Override
    public int get(String type) {
        return 0;
    }

    @Override
    public Map<String, Integer> getAll() {
        return null;
    }
}
