package com.bxm.game.common.core.assets.dao;

import com.bxm.game.common.core.AppConfigFetcher;
import com.bxm.game.common.core.Key;
import com.bxm.warcar.cache.Counter;
import com.bxm.warcar.cache.Fetcher;

import java.util.Map;
import java.util.Optional;

/**
 * @author allen
 * @date 2020-12-15
 * @since 1.0
 */
public class RedisAssetDaoImpl implements AssetDao {

    private final AppConfigFetcher appConfigFetcher;
    private final Fetcher fetcher;
    private final Counter counter;
    private final Key key;

    public RedisAssetDaoImpl(AppConfigFetcher appConfigFetcher, Fetcher fetcher, Counter counter, Key key) {
        this.appConfigFetcher = appConfigFetcher;
        this.fetcher = fetcher;
        this.counter = counter;
        this.key = key;
    }

    @Override
    public long plus(String type, int value) {
        return counter.hincrementByAndGet(key.getUserAsset(appConfigFetcher.assetWithApp()), type, value);
    }

    @Override
    public long minus(String type, int value) {
        return counter.hincrementByAndGet(key.getUserAsset(appConfigFetcher.assetWithApp()), type, -value);
    }

    @Override
    public int get(String type) {
        return Optional.ofNullable(fetcher.hfetch(key.getUserAsset(appConfigFetcher.assetWithApp()), type, Integer.class)).orElse(0);
    }

    @Override
    public Map<String, Integer> getAll() {
        return fetcher.hfetchall(key.getUserAsset(appConfigFetcher.assetWithApp()), Integer.class);
    }
}
