package com.bxm.game.common.core.interceptor;

import com.bxm.game.common.core.AppContext;
import com.bxm.game.common.core.activity.ActivityConfig;
import com.bxm.game.common.core.activity.ActivityService;
import com.bxm.warcar.integration.dc.dot.Device;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang.StringUtils;
import org.springframework.http.HttpStatus;
import org.springframework.web.servlet.HandlerInterceptor;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/**
 * @author allen
 * @date 2020-10-14
 * @since 1.0
 */
@Slf4j
public class AppContextInterceptor implements HandlerInterceptor {

    private final ActivityService activityService;

    public AppContextInterceptor(ActivityService activityService) {
        this.activityService = activityService;
    }

    @Override
    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        String appid = request.getHeader("x-appid");
        String device = request.getHeader("x-device");
        String did = request.getHeader("x-did");
        if (StringUtils.isBlank(appid) || StringUtils.isBlank(device)) {
            log.info("Required header name: 'appid' and 'device' is blank!");
            response.setStatus(HttpStatus.ACCEPTED.value());
            return false;
        }
        AppContext context = AppContext.getInstance();
        if (StringUtils.isNotBlank(did)) {
            Device deviceObject = Device.decrypt(did);
            context.setDevice(deviceObject);
        }
        context.setAppId(appid).setUid(device).setDid(did);
        ActivityConfig config = activityService.getConfig();
        context.setActivityConfig(config);
        return true;
    }

    @Override
    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) throws Exception {
        AppContext.remove();
    }
}
