package com.bxm.game.common.core.prop;

import lombok.Data;
import lombok.experimental.Accessors;

import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;

/**
 * @author allen
 * @date 2020-10-19
 * @since 1.0
 */
@Data
@Accessors(chain = true)
public class AcquiredPropLog {

    private String assetType;

    private String sceneType;
    private String id;
    private String appId;
    private String uid;

    /**
     * 道具数
     */
    private int propNum;
    /**
     * 翻倍数
     */
    private int multipleNum;
    /**
     * 是否已经翻倍处理了
     */
    private boolean completedMultiple;
    /**
     * 是否已兑换
     */
    private boolean acquired;
    /**
     * 可获取的时间
     */
    private long startAcquireTime;
    /**
     * 过期时间
     */
    private long endAcquireTime;

    /**
     * 来源。当被领取或翻倍后，这里是获取时的记录。
     */
    private AcquiredPropLog source;

    /**
     * 当前时间是否在可领取的有效时间内
     * @return 返回 true 则可领取
     */
    public boolean isBetweenAcquireTime() {
        return LocalDateTime.now().isAfter(getAcquireTimeInMillis()) &&
                (endAcquireTime == 0 || LocalDateTime.now().isBefore(getExpiredTimeInMillis()));
    }

    private LocalDateTime getAcquireTimeInMillis() {
        return LocalDateTime.ofInstant(Instant.ofEpochMilli(getStartAcquireTime()), ZoneId.systemDefault());
    }

    private LocalDateTime getExpiredTimeInMillis() {
        return LocalDateTime.ofInstant(Instant.ofEpochMilli(getEndAcquireTime()), ZoneId.systemDefault());
    }

    public com.bxm.game.common.dal.entity.AcquiredPropLog to() {
        com.bxm.game.common.dal.entity.AcquiredPropLog e = new com.bxm.game.common.dal.entity.AcquiredPropLog();
        e.setId(getId())
                .setAppId(getAppId())
                .setUid(getUid())
                .setAssetType(getAssetType())
                .setSceneType(getSceneType())
                .setPropNum(getPropNum())
                .setMultipleNum(getMultipleNum())
                .setCompletedMultiple(isCompletedMultiple())
                .setAcquired(isAcquired())
                .setStartAcquireTime(getStartAcquireTime())
                .setEndAcquireTime(getEndAcquireTime());
        return e;
    }

    public static AcquiredPropLog of(com.bxm.game.common.dal.entity.AcquiredPropLog e) {
        return new AcquiredPropLog()
                .setId(e.getId())
                .setAppId(e.getAppId())
                .setUid(e.getUid())
                .setAssetType(e.getAssetType())
                .setSceneType(e.getSceneType())
                .setPropNum(e.getPropNum())
                .setMultipleNum(e.getMultipleNum())
                .setCompletedMultiple(e.isTypeOfCompletedMultiple())
                .setAcquired(e.isTypeOfAcquired())
                .setStartAcquireTime(e.getStartAcquireTime())
                .setEndAcquireTime(e.getEndAcquireTime());
    }
}
