package com.bxm.game.common.core.prop;

import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.ConfigurableApplicationContext;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

/**
 * @author allen
 * @date 2020-11-26
 * @since 1.0
 */
public class PropGrantorFactory implements ApplicationListener<ApplicationReadyEvent> {

    private final ConcurrentHashMap<String, PropGrantor> grantors = new ConcurrentHashMap<>();

    @Override
    public void onApplicationEvent(ApplicationReadyEvent event) {
        ConfigurableApplicationContext applicationContext = event.getApplicationContext();
        Map<String, PropGrantor> beans = applicationContext.getBeansOfType(PropGrantor.class);
        for (PropGrantor service : beans.values()) {
            grantors.put(service.getAssetType(), service);
        }
    }

    public PropGrantor get(String assetType) {
        return grantors.get(assetType);
    }
}
