package com.bxm.game.common.core.prop;

import com.bxm.game.common.core.prop.dao.PropDao;
import lombok.extern.slf4j.Slf4j;

import java.util.Objects;

/**
 * @author allen
 * @date 2020-10-14
 * @since 1.0
 */
@Slf4j
public class PropServiceImpl implements PropService {

    private final PropDao propDao;
    private final PropGrantorFactory propGrantorFactory;

    public PropServiceImpl(PropDao propDao, PropGrantorFactory propGrantorFactory) {
        this.propDao = propDao;
        this.propGrantorFactory = propGrantorFactory;
    }

    @Override
    public boolean saveTakeLog(AcquiredPropLog log) {
        return propDao.saveTakeLog(log);
    }

    @Override
    public AcquiredPropLog getTakeLog(String id) {
        return propDao.getTakeLog(id);
    }

    @Override
    public Prop rebuild(AcquiredPropLog acquiredPropLog) {
        PropGrantor grantor = propGrantorFactory.get(acquiredPropLog.getAssetType());
        if (Objects.isNull(grantor)) {
            log.error("Not found PropGrantor of type: {}", acquiredPropLog.getAssetType());
            return null;
        }
        return grantor.rebuild(acquiredPropLog);
    }
}
