package com.bxm.game.common.core.scene;

import lombok.Getter;

import java.util.EventObject;

/**
 * 道具通过 以下 场景获取后触发的事件。
 *
 * <li>{@link com.bxm.game.common.core.scene.SceneType#ACQUIRE}</li>
 * <li>{@link com.bxm.game.common.core.scene.SceneType#MULTIPLE}</li>
 *
 * @author allen
 * @date 2020-12-02
 * @since 1.0
 */
@Getter
public class AcquiringOrMultiplyPropEvent extends EventObject {

    private final SceneRequest request;
    private final SceneResponse response;

    public AcquiringOrMultiplyPropEvent(Object source, SceneRequest request, SceneResponse response) {
        super(source);
        this.request = request;
        this.response = response;
    }
}
