package com.bxm.game.common.core.scene;

import com.google.common.collect.Maps;
import lombok.extern.slf4j.Slf4j;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.ConfigurableApplicationContext;

import java.util.Map;

/**
 * @author allen
 * @date 2020-10-16
 * @since 1.0
 */
@Slf4j
public class SceneServiceFactory implements ApplicationListener<ApplicationReadyEvent> {

    private final Map<String, SceneService> map = Maps.newHashMap();

    @Override
    public void onApplicationEvent(ApplicationReadyEvent event) {
        ConfigurableApplicationContext applicationContext = event.getApplicationContext();
        Map<String, SceneService> beans = applicationContext.getBeansOfType(SceneService.class);
        for (SceneService service : beans.values()) {
            map.put(service.getSceneType(), service);
            log.info("Registering SceneService to Factory: {}", service);
        }
    }

    public SceneService get(String sceneType) {
        return map.get(sceneType);
    }
}
