package com.bxm.game.common.core.scene.acquire;

import lombok.Getter;

import java.util.EventObject;

/**
 * 道具通过 {@link com.bxm.game.common.core.scene.SceneType#ACQUIRE} 场景获取后触发的事件。
 *
 * @author allen
 * @date 2020-12-02
 * @since 1.0
 */
@Getter
public class AcquiredSceneEvent extends EventObject {

    private final AcquireSceneRequest request;
    private final AcquireSceneResponse response;

    public AcquiredSceneEvent(Object source, AcquireSceneRequest request, AcquireSceneResponse response) {
        super(source);
        this.request = request;
        this.response = response;
    }
}
