package com.bxm.game.common.core.scene.event;

import com.bxm.game.common.core.prop.Prop;
import com.bxm.game.common.core.scene.SceneRequest;
import com.bxm.game.common.core.scene.SceneResponse;
import lombok.Getter;

import java.util.EventObject;
import java.util.Map;

/**
 * @author allen
 * @date 2020-10-15
 * @since 1.0
 */
@Getter
public class AcquiredPropEvent extends EventObject {

    private final String id;
    private final String sceneType;
    private final Prop prop;
    /**
     * 是否翻倍处理
     */
    private final boolean multiple;
    private final Map<Object, Object> attach;
    private final SceneRequest sceneRequest;
    private final SceneResponse sceneResponse;

    @Deprecated
    public AcquiredPropEvent(Object source, String id, String sceneType, Prop prop, boolean multiple) {
        this(source, id, sceneType, prop, multiple, null, null, null);
    }

    public AcquiredPropEvent(Object source, String id, String sceneType, Prop prop, boolean multiple,
                             Map<Object, Object> attach, SceneRequest sceneRequest, SceneResponse sceneResponse) {
        super(source);
        this.id = id;
        this.sceneType = sceneType;
        this.prop = prop;
        this.multiple = multiple;
        this.attach = attach;
        this.sceneRequest = sceneRequest;
        this.sceneResponse = sceneResponse;
    }
}
