package com.bxm.game.common.core.user.redis;

import com.bxm.game.common.core.AppConfigFetcher;
import com.bxm.game.common.core.Key;
import com.bxm.game.common.core.user.TemporaryAtomicService;
import com.bxm.warcar.cache.Counter;

import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;

/**
 * @author allen
 * @date 2020-12-22
 * @since 1.0
 */
public class RedisTemporaryAtomicServiceImpl implements TemporaryAtomicService {

    private final AppConfigFetcher appConfigFetcher;
    private final Counter counter;
    private final Key key;

    public RedisTemporaryAtomicServiceImpl(AppConfigFetcher appConfigFetcher, Counter counter, Key key) {
        this.appConfigFetcher = appConfigFetcher;
        this.counter = counter;
        this.key = key;
    }

    @Override
    public Map<String, Object> getAll() {
        throw new UnsupportedOperationException();
    }

    @Override
    public long get(String key) {
        return Optional.ofNullable(counter.hget(this.key.getTemporary(appConfigFetcher.temporaryWithApp()), key)).orElse(0L);
    }

    @Override
    public long incrementBy(String key, long value) {
        return Optional.ofNullable(counter.hincrementByAndGet(this.key.getTemporary(appConfigFetcher.temporaryWithApp()), key, value, Key.EXPIRE_TIME_TEN_MINUTES)).orElse(0L);
    }

    @Override
    public boolean incrementBy(String key, long value, Predicate<Long> predicate) {
        long l = this.incrementBy(key, value);
        return predicate.test(l);
    }
}
