package com.bxm.game.common.core.vo;

import com.bxm.game.common.core.archives.CustomArchiveHandlerFactory;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;

import java.util.Set;

/**
 * @author allen
 * @date 2020-12-01
 * @since 1.0
 * @deprecated We recommend using {@link CustomArchiveHandlerFactory}
 */
@Slf4j
@Deprecated
public class CustomArchiveFetcherFactory implements BeanPostProcessor {

    private final Set<CustomArchiveFetcher> fetchers = Sets.newHashSet();

    @Override
    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        if (bean instanceof CustomArchiveFetcher) {
            fetchers.add((CustomArchiveFetcher) bean);
            log.info("Registering CustomArchiveFetcher to Factory: {}", bean);
        }
        return bean;
    }

    public ImmutableSet<CustomArchiveFetcher> getFetchers() {
        return ImmutableSet.copyOf(fetchers);
    }
}
