package com.bxm.game.common.core.web;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

import com.bxm.game.common.core.AppConfigFetcher;
import com.bxm.game.common.core.activity.ActivityService;
import com.bxm.game.common.core.interceptor.AppContextInterceptor;
import com.bxm.game.common.core.interceptor.AppStatusInterceptor;
import org.springframework.context.annotation.Bean;
import org.springframework.core.Ordered;
import org.springframework.web.cors.CorsConfiguration;
import org.springframework.web.cors.UrlBasedCorsConfigurationSource;
import org.springframework.web.filter.CorsFilter;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

/**
 * @author allen
 * @date 2020-10-14
 * @since 1.0
 */
public class GlobalMvcConfigurer implements WebMvcConfigurer {

    private final ActivityService activityService;
    private final AppConfigFetcher appConfigFetcher;

    public GlobalMvcConfigurer(ActivityService activityService, AppConfigFetcher appConfigFetcher) {
        this.activityService = activityService;
        this.appConfigFetcher = appConfigFetcher;
    }

    @Bean
    public AppContextInterceptor appContextInterceptor() {
        return new AppContextInterceptor(activityService);
    }

    @Bean
    public AppStatusInterceptor appStatusInterceptor() {
        return new AppStatusInterceptor(appConfigFetcher);
    }

    @Override
    public void addInterceptors(InterceptorRegistry registry) {
        List<String> excludePathPatterns = Arrays.asList("/job/**");
        registry.addInterceptor(appStatusInterceptor())
                .order(Ordered.HIGHEST_PRECEDENCE)
                .addPathPatterns("/**")
                .excludePathPatterns(excludePathPatterns);

        registry.addInterceptor(appContextInterceptor())
                .order(Ordered.HIGHEST_PRECEDENCE + 1)
                .addPathPatterns("/**")
                .excludePathPatterns(excludePathPatterns)
                .excludePathPatterns(appConfigFetcher.excludePathPatternsOfAppContextInterceptor());
    }

    @Bean
    public CorsFilter corsFilter() {
        // 有 Interceptor 拦截器的情况下必须使用这种方式，不能使用该接口的 #addCorsMappings，否则可能因为顺序问题而跨域设置无效。
        CorsConfiguration configuration = new CorsConfiguration();
        configuration.addAllowedOrigin(CorsConfiguration.ALL);
        configuration.addAllowedHeader(CorsConfiguration.ALL);
        configuration.addAllowedMethod(CorsConfiguration.ALL);
        configuration.setAllowCredentials(true);

        UrlBasedCorsConfigurationSource source = new UrlBasedCorsConfigurationSource();
        source.registerCorsConfiguration("/**", configuration);
        return new CorsFilter(source);
    }
}
