/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.game.common.core.archives;

import com.bxm.game.common.core.archives.CustomArchive;
import com.bxm.game.common.core.archives.CustomArchiveDataService;
import com.bxm.game.common.core.archives.CustomArchiveHandler;
import com.bxm.game.common.core.archives.SceneCustomArchiveHandler;
import com.bxm.game.common.core.scene.SceneService;
import com.bxm.game.common.core.scene.event.AcquiredPropEvent;
import com.bxm.warcar.cache.KeyGenerator;
import com.bxm.warcar.integration.eventbus.EventListener;
import com.bxm.warcar.integration.eventbus.core.Subscribe;
import java.util.Objects;
import org.apache.commons.lang.StringUtils;

public class CustomArchiveHandlingListener
implements EventListener<AcquiredPropEvent> {
    private final CustomArchiveDataService customArchiveDataService;

    public CustomArchiveHandlingListener(CustomArchiveDataService customArchiveDataService) {
        this.customArchiveDataService = customArchiveDataService;
    }

    @Subscribe
    public void consume(AcquiredPropEvent event) {
        CustomArchiveHandler handler = this.getCustomArchiveHandler(event);
        if (Objects.isNull(handler)) {
            return;
        }
        if (!(handler instanceof SceneCustomArchiveHandler)) {
            return;
        }
        SceneCustomArchiveHandler sceneCustomArchiveHandler = (SceneCustomArchiveHandler)handler;
        String id = event.getId();
        KeyGenerator key = sceneCustomArchiveHandler.getKey();
        String field = sceneCustomArchiveHandler.getDisplayFieldName();
        Object object = sceneCustomArchiveHandler.createArchiveObject(event.getProp(), event.getAttach(), event.getSceneResponse());
        if (Objects.isNull(key) || StringUtils.isBlank((String)field) || Objects.isNull(object)) {
            return;
        }
        this.customArchiveDataService.hset(CustomArchive.builder().key(key.generateKey()).field(id).value(object).expireTimeInSeconds(sceneCustomArchiveHandler.getExpireTimeInSecond()).build());
    }

    private CustomArchiveHandler getCustomArchiveHandler(AcquiredPropEvent event) {
        Object source = event.getSource();
        CustomArchiveHandler handler = null;
        if (source instanceof CustomArchiveHandler) {
            handler = (CustomArchiveHandler)source;
        } else if (source instanceof SceneService) {
            handler = ((SceneService)source).getCustomArchiveHandler();
        }
        return handler;
    }
}

