/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.game.common.core.controllers;

import com.bxm.game.common.core.AppConfigFetcher;
import com.bxm.game.common.core.archives.CustomArchiveHandler;
import com.bxm.game.common.core.archives.CustomArchiveHandlerFactory;
import com.bxm.game.common.core.assets.AssetService;
import com.bxm.game.common.core.scene.signin.SigninService;
import com.bxm.game.common.core.user.PermanentAtomicService;
import com.bxm.game.common.core.user.TodayAtomicService;
import com.bxm.game.common.core.user.UserActiveService;
import com.bxm.game.common.core.vo.ArchiveVo;
import com.bxm.game.common.core.vo.AssetArchiveTransfer;
import com.bxm.game.common.core.vo.CustomArchiveFetcher;
import com.bxm.game.common.core.vo.CustomArchiveFetcherFactory;
import com.bxm.game.common.core.vo.DataTransfer;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/archive"})
public class ArchiveController {
    private static final Logger log = LoggerFactory.getLogger(ArchiveController.class);
    private final AppConfigFetcher appConfigFetcher;
    private final CustomArchiveFetcherFactory customArchiveFetcherFactory;
    private final CustomArchiveHandlerFactory customArchiveHandlerFactory;
    private final DataTransfer dataTransfer;
    private final AssetArchiveTransfer assetArchiveTransfer;
    private final TodayAtomicService todayAtomicService;
    private final PermanentAtomicService permanentAtomicService;
    private final AssetService assetService;
    private final UserActiveService userActiveService;
    private SigninService signinService;

    public ArchiveController(AppConfigFetcher appConfigFetcher, CustomArchiveFetcherFactory customArchiveFetcherFactory, CustomArchiveHandlerFactory customArchiveHandlerFactory, DataTransfer dataTransfer, AssetArchiveTransfer assetArchiveTransfer, TodayAtomicService todayAtomicService, PermanentAtomicService permanentAtomicService, AssetService assetService, UserActiveService userActiveService) {
        this.appConfigFetcher = appConfigFetcher;
        this.customArchiveFetcherFactory = customArchiveFetcherFactory;
        this.customArchiveHandlerFactory = customArchiveHandlerFactory;
        this.dataTransfer = dataTransfer;
        this.assetArchiveTransfer = assetArchiveTransfer;
        this.todayAtomicService = todayAtomicService;
        this.permanentAtomicService = permanentAtomicService;
        this.assetService = assetService;
        this.userActiveService = userActiveService;
    }

    @Autowired(required=false)
    public void setSigninService(SigninService signinService) {
        this.signinService = signinService;
    }

    @GetMapping(value={"/fetch"})
    public ResponseEntity<ArchiveVo> fetch() {
        HashMap custom = Maps.newHashMap();
        ImmutableSet<CustomArchiveFetcher> fetchers = this.customArchiveFetcherFactory.getFetchers();
        for (CustomArchiveFetcher fetcher : fetchers) {
            String key = fetcher.getKey();
            if (custom.containsKey(key)) {
                log.warn("duplicated key: {}", (Object)key);
            }
            custom.put(key, fetcher.getValue());
        }
        ImmutableSet<CustomArchiveHandler> handlers = this.customArchiveHandlerFactory.getHandlers();
        for (CustomArchiveHandler handler : handlers) {
            String displayFieldName = handler.getDisplayFieldName();
            if (custom.containsKey(displayFieldName)) {
                log.warn("duplicated key: {}", (Object)displayFieldName);
            }
            custom.put(displayFieldName, handler.getArchiveObjects());
        }
        ArchiveVo.ArchiveVoBuilder builder = ArchiveVo.builder().today(this.dataTransfer.transfer(this.todayAtomicService.getAll())).permanent(this.dataTransfer.transfer(this.permanentAtomicService.getAll())).assets(this.assetArchiveTransfer.transfer(this.assetService.getAll())).custom(custom).time(System.currentTimeMillis());
        if (Objects.nonNull(this.signinService)) {
            builder.continuousSignInDays(this.signinService.getContinuousSignInTimes());
        }
        if (this.appConfigFetcher.activatingOnFetchArchive()) {
            this.userActiveService.active();
        }
        if (this.appConfigFetcher.showUserActiveDays()) {
            builder.activeDays(this.userActiveService.getActiveDays());
        }
        return ResponseEntity.ok((Object)builder.build());
    }
}

