/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.game.common.core.prop;

import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Map;

public class AcquiredPropLog {
    private String assetType;
    private String sceneType;
    private String id;
    private String appId;
    private String uid;
    private int propNum;
    private int multipleNum;
    private boolean completedMultiple;
    private boolean acquired;
    private long startAcquireTime;
    private long endAcquireTime;
    private AcquiredPropLog source;
    private Map<String, Object> ext;

    public boolean isBetweenAcquireTime() {
        return LocalDateTime.now().isAfter(this.getAcquireTimeInMillis()) && (this.endAcquireTime == 0L || LocalDateTime.now().isBefore(this.getExpiredTimeInMillis()));
    }

    private LocalDateTime getAcquireTimeInMillis() {
        return LocalDateTime.ofInstant(Instant.ofEpochMilli(this.getStartAcquireTime()), ZoneId.systemDefault());
    }

    private LocalDateTime getExpiredTimeInMillis() {
        return LocalDateTime.ofInstant(Instant.ofEpochMilli(this.getEndAcquireTime()), ZoneId.systemDefault());
    }

    public com.bxm.game.common.dal.entity.AcquiredPropLog to() {
        com.bxm.game.common.dal.entity.AcquiredPropLog e = new com.bxm.game.common.dal.entity.AcquiredPropLog();
        e.setId(this.getId()).setAppId(this.getAppId()).setUid(this.getUid()).setAssetType(this.getAssetType()).setSceneType(this.getSceneType()).setPropNum(Integer.valueOf(this.getPropNum())).setMultipleNum(Integer.valueOf(this.getMultipleNum())).setCompletedMultiple(this.isCompletedMultiple()).setAcquired(this.isAcquired()).setStartAcquireTime(Long.valueOf(this.getStartAcquireTime())).setEndAcquireTime(Long.valueOf(this.getEndAcquireTime()));
        return e;
    }

    public static AcquiredPropLog of(com.bxm.game.common.dal.entity.AcquiredPropLog e) {
        return new AcquiredPropLog().setId(e.getId()).setAppId(e.getAppId()).setUid(e.getUid()).setAssetType(e.getAssetType()).setSceneType(e.getSceneType()).setPropNum(e.getPropNum()).setMultipleNum(e.getMultipleNum()).setCompletedMultiple(e.isTypeOfCompletedMultiple()).setAcquired(e.isTypeOfAcquired()).setStartAcquireTime(e.getStartAcquireTime()).setEndAcquireTime(e.getEndAcquireTime());
    }

    public String getAssetType() {
        return this.assetType;
    }

    public String getSceneType() {
        return this.sceneType;
    }

    public String getId() {
        return this.id;
    }

    public String getAppId() {
        return this.appId;
    }

    public String getUid() {
        return this.uid;
    }

    public int getPropNum() {
        return this.propNum;
    }

    public int getMultipleNum() {
        return this.multipleNum;
    }

    public boolean isCompletedMultiple() {
        return this.completedMultiple;
    }

    public boolean isAcquired() {
        return this.acquired;
    }

    public long getStartAcquireTime() {
        return this.startAcquireTime;
    }

    public long getEndAcquireTime() {
        return this.endAcquireTime;
    }

    public AcquiredPropLog getSource() {
        return this.source;
    }

    public Map<String, Object> getExt() {
        return this.ext;
    }

    public AcquiredPropLog setAssetType(String assetType) {
        this.assetType = assetType;
        return this;
    }

    public AcquiredPropLog setSceneType(String sceneType) {
        this.sceneType = sceneType;
        return this;
    }

    public AcquiredPropLog setId(String id) {
        this.id = id;
        return this;
    }

    public AcquiredPropLog setAppId(String appId) {
        this.appId = appId;
        return this;
    }

    public AcquiredPropLog setUid(String uid) {
        this.uid = uid;
        return this;
    }

    public AcquiredPropLog setPropNum(int propNum) {
        this.propNum = propNum;
        return this;
    }

    public AcquiredPropLog setMultipleNum(int multipleNum) {
        this.multipleNum = multipleNum;
        return this;
    }

    public AcquiredPropLog setCompletedMultiple(boolean completedMultiple) {
        this.completedMultiple = completedMultiple;
        return this;
    }

    public AcquiredPropLog setAcquired(boolean acquired) {
        this.acquired = acquired;
        return this;
    }

    public AcquiredPropLog setStartAcquireTime(long startAcquireTime) {
        this.startAcquireTime = startAcquireTime;
        return this;
    }

    public AcquiredPropLog setEndAcquireTime(long endAcquireTime) {
        this.endAcquireTime = endAcquireTime;
        return this;
    }

    public AcquiredPropLog setSource(AcquiredPropLog source) {
        this.source = source;
        return this;
    }

    public AcquiredPropLog setExt(Map<String, Object> ext) {
        this.ext = ext;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AcquiredPropLog)) {
            return false;
        }
        AcquiredPropLog other = (AcquiredPropLog)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getPropNum() != other.getPropNum()) {
            return false;
        }
        if (this.getMultipleNum() != other.getMultipleNum()) {
            return false;
        }
        if (this.isCompletedMultiple() != other.isCompletedMultiple()) {
            return false;
        }
        if (this.isAcquired() != other.isAcquired()) {
            return false;
        }
        if (this.getStartAcquireTime() != other.getStartAcquireTime()) {
            return false;
        }
        if (this.getEndAcquireTime() != other.getEndAcquireTime()) {
            return false;
        }
        String this$assetType = this.getAssetType();
        String other$assetType = other.getAssetType();
        if (this$assetType == null ? other$assetType != null : !this$assetType.equals(other$assetType)) {
            return false;
        }
        String this$sceneType = this.getSceneType();
        String other$sceneType = other.getSceneType();
        if (this$sceneType == null ? other$sceneType != null : !this$sceneType.equals(other$sceneType)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$appId = this.getAppId();
        String other$appId = other.getAppId();
        if (this$appId == null ? other$appId != null : !this$appId.equals(other$appId)) {
            return false;
        }
        String this$uid = this.getUid();
        String other$uid = other.getUid();
        if (this$uid == null ? other$uid != null : !this$uid.equals(other$uid)) {
            return false;
        }
        AcquiredPropLog this$source = this.getSource();
        AcquiredPropLog other$source = other.getSource();
        if (this$source == null ? other$source != null : !((Object)this$source).equals(other$source)) {
            return false;
        }
        Map<String, Object> this$ext = this.getExt();
        Map<String, Object> other$ext = other.getExt();
        return !(this$ext == null ? other$ext != null : !((Object)this$ext).equals(other$ext));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AcquiredPropLog;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getPropNum();
        result = result * 59 + this.getMultipleNum();
        result = result * 59 + (this.isCompletedMultiple() ? 79 : 97);
        result = result * 59 + (this.isAcquired() ? 79 : 97);
        long $startAcquireTime = this.getStartAcquireTime();
        result = result * 59 + (int)($startAcquireTime >>> 32 ^ $startAcquireTime);
        long $endAcquireTime = this.getEndAcquireTime();
        result = result * 59 + (int)($endAcquireTime >>> 32 ^ $endAcquireTime);
        String $assetType = this.getAssetType();
        result = result * 59 + ($assetType == null ? 43 : $assetType.hashCode());
        String $sceneType = this.getSceneType();
        result = result * 59 + ($sceneType == null ? 43 : $sceneType.hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $appId = this.getAppId();
        result = result * 59 + ($appId == null ? 43 : $appId.hashCode());
        String $uid = this.getUid();
        result = result * 59 + ($uid == null ? 43 : $uid.hashCode());
        AcquiredPropLog $source = this.getSource();
        result = result * 59 + ($source == null ? 43 : ((Object)$source).hashCode());
        Map<String, Object> $ext = this.getExt();
        result = result * 59 + ($ext == null ? 43 : ((Object)$ext).hashCode());
        return result;
    }

    public String toString() {
        return "AcquiredPropLog(assetType=" + this.getAssetType() + ", sceneType=" + this.getSceneType() + ", id=" + this.getId() + ", appId=" + this.getAppId() + ", uid=" + this.getUid() + ", propNum=" + this.getPropNum() + ", multipleNum=" + this.getMultipleNum() + ", completedMultiple=" + this.isCompletedMultiple() + ", acquired=" + this.isAcquired() + ", startAcquireTime=" + this.getStartAcquireTime() + ", endAcquireTime=" + this.getEndAcquireTime() + ", source=" + this.getSource() + ", ext=" + this.getExt() + ")";
    }
}

