/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.game.common.core.scene.listeners;

import com.bxm.game.common.core.prop.Prop;
import com.bxm.game.common.core.prop.PropGrantor;
import com.bxm.game.common.core.scene.event.AcquiredPropEvent;
import com.bxm.warcar.integration.eventbus.EventListener;
import com.bxm.warcar.integration.eventbus.core.Subscribe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.Order;

@Order(value=-2147483648)
public class GrantPropListener
implements EventListener<AcquiredPropEvent> {
    private static final Logger log = LoggerFactory.getLogger(GrantPropListener.class);
    private final PropGrantor grantor;

    public GrantPropListener(PropGrantor grantor) {
        this.grantor = grantor;
    }

    @Subscribe
    public void consume(AcquiredPropEvent event) {
        Prop prop = event.getProp();
        if (!prop.acquired()) {
            return;
        }
        if (event.isMultiple() && prop.multipleNum() > 1) {
            this.grantor.multiple(prop);
        } else {
            this.grantor.single(prop);
        }
    }
}

