/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.game.common.core.user.redis;

import com.bxm.game.common.core.AppConfigFetcher;
import com.bxm.game.common.core.Key;
import com.bxm.game.common.core.system.RuntimeClock;
import com.bxm.game.common.core.user.UserActiveService;
import com.bxm.warcar.cache.Fetcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;

public class RedisUserActiveServiceImpl
implements UserActiveService {
    private static final Logger log = LoggerFactory.getLogger(RedisUserActiveServiceImpl.class);
    private final AppConfigFetcher appConfigFetcher;
    private final Key key;
    private final Fetcher fetcher;
    private final RuntimeClock runtimeClock;

    public RedisUserActiveServiceImpl(AppConfigFetcher appConfigFetcher, Key key, Fetcher fetcher, RuntimeClock runtimeClock) {
        this.appConfigFetcher = appConfigFetcher;
        this.key = key;
        this.fetcher = fetcher;
        this.runtimeClock = runtimeClock;
    }

    @Override
    public void active() {
        JedisPool jedisPool = this.getJedisPool();
        try (Jedis jedis = jedisPool.getResource();){
            jedis.setbit(this.getKey(), this.runtimeClock.getRuntimeDays(), true);
        }
    }

    @Override
    public long getActiveDays() {
        JedisPool jedisPool = this.getJedisPool();
        try (Jedis jedis = jedisPool.getResource();){
            long l = jedis.bitcount(this.getKey());
            return l;
        }
    }

    @Override
    public void clean() {
        JedisPool pool = this.getJedisPool();
        try (Jedis jedis = pool.getResource();){
            jedis.del(this.getKey());
        }
    }

    private String getKey() {
        return this.key.bitmapActive(this.appConfigFetcher.activeWithApp()).generateKey();
    }

    private JedisPool getJedisPool() {
        Object original = this.fetcher.getClientOriginal();
        if (!(original instanceof JedisPool)) {
            throw new RuntimeException("originalClient is not JedisPool!");
        }
        return (JedisPool)original;
    }
}

