/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.game.common.core.web;

import com.bxm.game.common.core.AppConfigFetcher;
import com.bxm.game.common.core.activity.ActivityService;
import com.bxm.game.common.core.interceptor.AppContextInterceptor;
import com.bxm.game.common.core.interceptor.AppStatusInterceptor;
import com.bxm.game.common.core.user.dao.UserDao;
import java.util.Arrays;
import java.util.List;
import org.springframework.context.annotation.Bean;
import org.springframework.web.cors.CorsConfiguration;
import org.springframework.web.cors.CorsConfigurationSource;
import org.springframework.web.cors.UrlBasedCorsConfigurationSource;
import org.springframework.web.filter.CorsFilter;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

public class GlobalMvcConfigurer
implements WebMvcConfigurer {
    private final ActivityService activityService;
    private final AppConfigFetcher appConfigFetcher;
    private final UserDao userDao;

    public GlobalMvcConfigurer(ActivityService activityService, AppConfigFetcher appConfigFetcher, UserDao userDao) {
        this.activityService = activityService;
        this.appConfigFetcher = appConfigFetcher;
        this.userDao = userDao;
    }

    @Bean
    public AppContextInterceptor appContextInterceptor() {
        return new AppContextInterceptor(this.userDao);
    }

    @Bean
    public AppStatusInterceptor appStatusInterceptor() {
        return new AppStatusInterceptor(this.appConfigFetcher);
    }

    public void addInterceptors(InterceptorRegistry registry) {
        List<String> excludePathPatterns = Arrays.asList("/job/**");
        registry.addInterceptor((HandlerInterceptor)this.appStatusInterceptor()).order(Integer.MIN_VALUE).addPathPatterns(new String[]{"/**"}).excludePathPatterns(excludePathPatterns);
        registry.addInterceptor((HandlerInterceptor)this.appContextInterceptor()).order(-2147483647).addPathPatterns(new String[]{"/**"}).excludePathPatterns(excludePathPatterns).excludePathPatterns(this.appConfigFetcher.excludePathPatternsOfAppContextInterceptor());
    }

    @Bean
    public CorsFilter corsFilter() {
        CorsConfiguration configuration = new CorsConfiguration();
        configuration.addAllowedOrigin("*");
        configuration.addAllowedHeader("*");
        configuration.addAllowedMethod("*");
        configuration.setAllowCredentials(Boolean.valueOf(true));
        UrlBasedCorsConfigurationSource source = new UrlBasedCorsConfigurationSource();
        source.registerCorsConfiguration("/**", configuration);
        return new CorsFilter((CorsConfigurationSource)source);
    }
}

