package com.bxm.game.common.core;


import com.bxm.warcar.integration.dc.dot.Device;

/**
 * @author allen
 * @date 2020-10-14
 * @since 1.0
 */
public class AppContext {

    private static final ThreadLocal<AppContext> THREAD_LOCAL = new ThreadLocal<>();

    public static AppContext getInstance() {
        AppContext appContext = THREAD_LOCAL.get();
        if (null == appContext) {
            appContext = new AppContext();
            THREAD_LOCAL.set(appContext);
        }
        return appContext;
    }

    public static AppContext get() {
        return THREAD_LOCAL.get();
    }

    public static void remove() {
        THREAD_LOCAL.remove();
    }

    private String appId;
    /**
     * x-device 设备uid
     */
    private String devUid;
    /**
     * 自定义用户id
     */
    private String uid;
    private String did;
    private Device device;
    /**
     * 时效数据锚定日期
     */
    private String boundAnchor;
    /**
     * 时效数据最终过期时间戳
     */
    private long boundLimit;

    public AppContext setAppId(String appId) {
        this.appId = appId;
        return this;
    }

    public String getAppId() {
        return appId;
    }

    public AppContext setDevUid(String devUid) {
        this.devUid = devUid;
        return this;
    }

    public String getDevUid() {
        return devUid;
    }

    public AppContext setUid(String uid) {
        this.uid = uid;
        return this;
    }

    public String getUid() {
        return uid;
    }

    public String getDid() {
        return did;
    }

    public AppContext setDid(String did) {
        this.did = did;
        return this;
    }

    public Device getDevice() {
        return device;
    }

    public AppContext setDevice(Device device) {
        this.device = device;
        return this;
    }

    public String getBoundAnchor() {
        return boundAnchor;
    }

    public void setBoundAnchor(String boundAnchor) {
        this.boundAnchor = boundAnchor;
    }

    public long getBoundLimit() {
        return boundLimit;
    }

    public void setBoundLimit(long boundLimit) {
        this.boundLimit = boundLimit;
    }
}
