package com.bxm.game.common.core;

import java.util.Calendar;
import java.util.Date;

import com.bxm.warcar.utils.DateHelper;

/**
 * 公共辅助类<br/>
 *
 * @author kerry.jiang
 * @date 2021/4/16 9:43
 */
public class CommonHelper {

    /**
     * 锚定日期为第一天，今日是第几天
     */
    public static int orderDays(){
        return orderDays(AppContext.get().getBoundAnchor(), new Date());
    }

    /**
     * startYmd日期为第一天，end是第几天
     * @param startYmd {yyyyMMdd}格式的日期
     * @param end end 日期
     */
    public static int orderDays(String startYmd, Date end){
        Date start = DateHelper.parse(startYmd, DateHelper.PATTERN_STR8);
        return orderDays(start, end);
    }

    /**
     * start日期为第一天，end是第几天
     * @param start 日期
     * @param end 日期
     */
    public static int orderDays(Date start, Date end){
        Calendar c1 = Calendar.getInstance();
        c1.setTime(start);
        c1.set(Calendar.HOUR_OF_DAY, 0);
        c1.set(Calendar.MINUTE, 0);
        c1.set(Calendar.SECOND, 0);
        c1.set(Calendar.MILLISECOND, 0);

        Calendar c2 = Calendar.getInstance();
        c2.setTime(end);
        c2.set(Calendar.HOUR_OF_DAY, 0);
        c2.set(Calendar.MINUTE, 0);
        c2.set(Calendar.SECOND, 0);
        c2.set(Calendar.MILLISECOND, 0);

        return (int)Math.round((c2.getTimeInMillis() - c1.getTimeInMillis()) / 86400000D) + 1;
    }
}
